;**********************************************************************
;  Pijma DO pro zesilova s atenutorem PGA2311 a rotanm koderem *
;**********************************************************************
;    Filename:	    rx-rotpga.asm                                     *
;    Author:        Jaroslav Belza                                    *
;**********************************************************************
;                           ----------U-----------  
;    sriov vstup CLOCK <-|RA2              RA1|-> sriov vstup STROBE
; zapnut zesilovae ONSW <-|RA3              RA0|-> sriov vstup DATA, tlatka sloupec 1
;           indikace MUTE ->|RA4(OC)          RA7|-> tlatka sloupec 2
;         input MODE, Vpp ->|RA5/MCLR         RA6|-> tlatka sloupec 3
;                     GND --|Vss              Vdd|-- +5V
;      vstup signlu z RX ->|RB0/INT      RB7/PGD|<- tlatka dek 4, PGD
;   hldn napjen PWFI ->|RB1          RB6/PGC|<- tlatka dek 3, PGC
;        tlatka dek 1 ->|RB2              RB5|<- koder B
;        tlatka dek 2 ->|RB3          RB4/PGM|<- koder A
;                           ----------------------
;**********************************************************************

	list      p=16f628a           ; list directive to define processor
	#include <p16f628a.inc>        ; processor specific variable definitions

	errorlevel  -302              ; suppress message 302 from list file

	__CONFIG   _CP_OFF & _CPD_OFF & _LVP_OFF & _BOREN_OFF & _MCLRE_OFF & _WDT_ON & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT



;***** VARIABLE DEFINITIONS
w_temp        EQU     0x7e        ; variable used for context saving 
status_temp   EQU     0x7f        ; variable used for context saving

olden	equ	0x21	;pedchoz stav encoderu - RB4 a RB5 pro RBINT
newen	equ	0x22	;aktuln stav encoderu
chen	equ	0x23	;zmna stavu encoderu
;
tmp		equ	0x24	;promnn zpoovac smyky
kbcode	equ	0x25	;kd mstnch tlatek
sdbuf	equ	0x26	;odtud se poslaj data do sriovho posuvnho registru (4094, HC595)
temp	equ	0x27	;pomocn registr
timer	equ	0x28	;uloen obsah TMR0
pdat	equ	0x29	;pijat byte
kdat	equ	0x2a	;kontroln byte
plast	equ	0x2b	;posledn povel (pouv volume)
cimp	equ	0x2c	;poitn pijatch bit (dekrementuje se)
ksl 	equ	0x2d	;pro vpoet kdu tlatka
;
volume	equ	0x30	; hlasitost
volpga	equ	0x31	; hlasitost pro PGA
balance	equ	0x32	; balance
balneg	equ	0x33	; zporn hodnota balance pro lev kanl
volumel	equ	0x34	; hlasitost lev kanl (potenciometr)
volumer	equ	0x35	; hlasitost prav kanl (potenciometr)
dlstep	equ	0x36	; prodleva po prvnm kroku
dsta	equ	0x38	; displej stovky
ddes	equ	0x39	; displej destky
djed	equ	0x3a	; displej jednotky
tmpdis	equ	0x3b	; asovn zmny funkce displeje (n * 5 ms)
tmpkb	equ 0x3c	; asovn ten tlatek
tmpimp	equ	0x3d	; asovn povelu typu impuls
portx	equ	0x3f	; vstupy sriovho pos. registru 74HC595
;					  |x|x|x|x|x|x|x|x| pznaky
;					   | | | | | | | +- mute (navzno na vstup MUTE PGA2311)
;					   | | | | | | +--- SP1 - reproduktory 1
;					   | | | | | +----- SP2 - reproduktory 2
;					   | | | | +------- BF1 - bit. funkce 1
;					   | | | +--------- BF2 - bit. funkce 2
;					   | | +----------- IN1 - vstup 1
;					   | +------------- IN2 - vstup 2
;					   +--------------- IN3 - vstup 3
	#define	MUTE	portx,0		; mute
	#define	SPSW1	portx,1		; reproduktory 1
	#define	SPSW2	portx,2		; reproduktory 2
	#define	BITF1	portx,3		; bit. funkce 1
	#define	BITF2	portx,4		; bit. funkce 2
	#define	INP3	portx,5		; vstup 3
	#define	INP2	portx,6		; vstup 2
	#define	INP1	portx,7		; vstup 1
;
flags	equ	0x70	; pznaky
;					  |x|x|x|x|x|x|x|x|
;					   | | | | | | | +- 1 - nov data
;					   | | | | | | +--- 1 - povel pijat
;					   | | | | | +----- 1 - 
;					   | | | | +------- 1 - 1.povel z mstnch tlatek
;					   | | | +--------- 1 - prznak stisknut mstnho tlacitka
;					   | | +----------- 1 - prznak stisknut vce mstnch tlacitek
;					   | +------------- 1 - povel typu impuls
;					   +--------------- 1 - poadavek na zpis dat do sriovho registru - pipravena nov data
	#define	NDATA	flags,0		; nov data
	#define	RXCOMM	flags,1		; povel pijat
;	#define	LOCOMM	flags,2		; povel z mstnch tlatek
	#define	FIRSTC	flags,3		; 1. povel z mstnch tlatek
	#define	LOPUSH	flags,4		; prznak stisknut mstnho tlacitka
	#define	MPUSH	flags,5		; prznak stisknut vce mstnch tlacitek
	#define	IMPS	flags,6		; povel typu impuls
	#define	XDAT	flags,7		; poadavek na zpis dat do sriovho registru
;
tmr1f	equ	2fh		; pznaky pro pouvn TMR1
;					  |x|x|x|x|x|x|x|x|
;					;  | | | | | | | +- 1 - displej zobraz balanci
;					;  | | | | | | +--- 1 - 
;					;  | | | | | +----- 1 - 
;					;  | | | | +------- 1 - 
;					;  | | | +--------- 1 - asova TMR1 je pouit pro rotan koder
;					;  | | +----------- 1 - 
;					;  | +------------- 1 - nepouito
;					;  +--------------- 1 - nepouito
	#define	DBAL	tmr1f,0		; displej zobraz balanci
	#define	RCOD	tmr1f,4		; asova TMR1 je pouit pro rotan koder
;
memdata	equ	72h		; data pro uloen do EEPROM
;
	#define	DDAT	PORTA,0		; sriov vstup - data
	#define	DSTR	PORTA,1		; sriov vstup - pepis
	#define	DCLK	PORTA,2		; sriov vstup - data, tlatka sloupec 1
	#define	SWC1	PORTA,0		; vstup tlatka sloupec 1 (sdleno s DATA !!)
	#define	ONSW	PORTA,3		; vstup - signl zapnut (1 = zapnuto)
	#define	MUTEI	PORTA,4		; vstup indikace MUTE
	#define	MODE	PORTA,5		; vstup pro vbr zpsobu pepnn vstup
	#define	SWC3	PORTA,6		; vstup tlatka sloupec 3
	#define	SWC2	PORTA,7		; vstup tlatka sloupec 2
;
	#define	IRIN	PORTB,0		; vstup od pijmae DO
	#define	PWFI	PORTB,1		; vstup detekce vypnut (power fail indicator)
	#define	SWR1	PORTB,2		; vstup tlatka dek 1
	#define	SWR2	PORTB,3		; vstup tlatka dek 2
	#define	SWR5	PORTB,4		; vstup koder, tlatka dek 5
	#define	SWR6	PORTB,5		; vstup koder
	#define	SWR3	PORTB,6		; vstup tlatka dek 3
	#define	SWR4	PORTB,7		; vstup tlatka dek 4


;**********************************************************************
		ORG	0x000	; processor reset vector

	bcf 	STATUS,RP0		; set file register bank to 0
	clrf	PORTA			;(0)vynuluj port A
	clrf	PORTB			;(0)vynuluj port B
 	goto	init			; go to beginning of program

		ORG	0x004	; interrupt vector location
	movwf	w_temp			; save off current W register contents
	movf	STATUS,w		; move status register into W register
	movwf	status_temp		; save off contents of STATUS register
;
	btfsc	INTCON,RBIF		;peruen od zmny RB?
	goto	rbint			; ano
	btfss	INTCON,T0IF		;peruen od TMR0?
	goto	indata			; ne
; peruen od asovae - petekl asova
	bsf		STATUS,RP0		;bank 1
	bsf 	OPTION_REG,T0CS	;(1)zastav asova pipojenm vstupu na RA4
	bsf 	NDATA			;nastav pznak "nov data"
	bcf 	INTCON,T0IE		;zaka peruen od asovae
	bcf 	INTCON,T0IF		;nuluj pznak peteen TMR0
	goto	errint
indata ; pijat impuls na GP2/INT
	bcf		STATUS,RP0		;Bank 0
	btfss	INTCON,INTF		;peruen od RB0/INT?
	goto	errint			;ne CHYBA !! - nemlo by nastat
	bcf 	INTCON,INTF		;nuluj pznak peteen RB0/INT

	btfss	NDATA			;test pznaku "nov data". Pokud je pznak nastaven
							;me to bt prvn impuls povelu
	goto	datatst			;nen to prvn impuls
	bcf 	NDATA			;nuluj pznak "nov data"
	movlw	.8				;oekvan poet pijatch bit
	movwf	cimp
	clrf	TMR0			;(0)nuluj ta
	clrf	pdat			;nuluj registry pro natn pijatch dat
	clrf	kdat
	bsf		STATUS,RP0		;Bank 1
	bcf 	OPTION_REG,T0CS	;(1)spus asova pipojenm vstupu na CLKOUT
	bcf 	INTCON,INTF		;nuluj pznak peruen od RB0/INT
	bsf 	INTCON,T0IE		;povol peruen od asovae TMR0
	goto	endint

datatst	;podle stavu asovae se ur krtk chyba, bity 00, 01, 10, 11 nebo dlouh chyba
	movfw	TMR0		;(0)pesu obsah TMR0
	clrf	TMR0		;(0)nuluj ta
	movwf	timer		;
;te1
	movlw	0x6f		;111 do WREG
	addwf	timer,w		;sete timer a WREG. Kdy souet petee, byl timer >145
	btfsc	STATUS,C	;test CARRY
	goto	errdata		;byl dlouh
	movlw	0x39		;57 do WREG
	subwf	timer,w		;odete WREG od timer. Kdy rozdl podtee, byl timer <57
	btfss	STATUS,C	;test CARRY
	goto	errdata		;byl krtk
; rozdlen na skupiny 0x a 1x
	movlw	0xa5		;165 do WREG - hranin hodnota mezi 01 a 10
	addwf	timer,w		;pite hranin hodnotu k timer. Kdy petee C=1 jsou pijaty bity 10 nebo 11
	btfsc	STATUS,C	;test CARRY
	goto	data10		;byl "10"
; test pro "00" a "01"
	rlf 	kdat,f		;CARRY=0, prvn nulu sta narolovat
	rlf 	pdat,f
	movlw	0xb8		;184 do WREG - hranin hodnota mezi 00 a 01
	addwf	timer,w		;pite hranin hodnotu k timer. Kdy petee C=1 jsou pijaty bity 01
	rlf 	kdat,f		;CARRY nastaven, sta narolovat
	rlf 	pdat,f
	goto	next
data10 ; test pro "10" a "11"
	rlf 	kdat,f		;CARRY=1, prvn 1 sta narolovat
	rlf 	pdat,f
	movlw	0x8d		;141 do WREG - hranin hodnota mezi 10 a 11
	addwf	timer,w		;pite hranin hodnotu k timer. Kdy petee C=1 jsou pijaty bity 11
	rlf 	kdat,f		;CARRY nastaven, sta narolovat
	rlf 	pdat,f
next
	decfsz	cimp,f		;pijat dal bit, odpotej
	goto	endint
	bsf 	RXCOMM		;nastav pznak "povel pijat"
errdata
	bsf 	NDATA		;nastav pznak "nov data"
	clrf	cimp		;nuluj poitadlo (asi nen nutn)
errint	;peruen nen od asovae TMR0 ani od RB0/INT. Nastavit znova
		;INTCON, OPTION_REG, ppadn PIE1 a PIR1 (budou-li pouity)
	bcf		STATUS,RP0	;bank 0
	clrf	TMR0		;(0)nuluj asova
endint
	movf	status_temp,w	; retrieve copy of STATUS register
	movwf	STATUS			; restore pre-isr STATUS register contents
	swapf	w_temp,f
	swapf	w_temp,w		; restore pre-isr W register contents
	retfie					; return from interrupt
rbint ; zpracovn peruen od RB (koder)
;http://www.piclist.com/techref/postbot.asp?by=thread&id=%5BPIC%5D%3A+Stumped+by+rotary+encoder&w=body&tgt=post
	clrwdt
	movf	PORTB,w		; nati port B
	andlw	0x30		; zajmaj ns jen bity 4 a 5
	movwf	newen		; a ulo
	xorwf	olden,w		; zjisti zmny proti pvodnmu stavu
	movwf	chen
	btfss	chen,4		; zmnil se stav A - SWR5?
	goto	rbintend	;  ne - konec
	btfss	newen,4		; kdy A=1, tak zmna A (SWR5) 0->1
	goto	rbifall
;rbi rise - zmna A (SWR5) 0->1
	btfss	newen,5		; kdy B=0, smr CW
	goto	rbicv
	goto	rbiccv
rbifall		; zmna A (SWR5) 1->0
	btfss	newen,5		; kdy B=0, smr CCW
	goto	rbiccv
	goto	rbicv
rbiccv		; smr CCV
	call	vodwn
	goto	rbiupd
rbicv		; smr CV
	call	voup
rbiupd
	call	tmrkoder
	movfw	newen		; stav portu RB4 a RB5
	movwf	olden		; ulo zmnu
	bsf 	XDAT		; nastav pznak, e se maj poslat data
rbintend
	bcf 	INTCON,RBIF	; nuluj pznak zmny RB
	goto	endint		; hotovo

init
; kompartor off
	movlw	0x07		;vypne kompartor zpisem do CMCON
	movwf	CMCON		;(0)vvody RA0 a RA4 pak lze pout jako I/O
; port & TMR0 set
	bsf		STATUS,RP0	;Bank 1
	movlw	0x20		;RA5 je vstup, ostatn RA vstupy
	movwf	TRISA		;(1) nastav I/O
	movlw	0xff		;RB0-RB7 jsou vstupy
	movwf	TRISB		;(1) nastav I/O
	movlw	0x33		;zapni WPU, peruen RB0/INT na sestupnou hranu,
	movwf	OPTION_REG	;(1) asova TMR0 vypnut pipojenm na RA4,dlika 16 pro asova
; konfigurace peruen
	movlw	0xb0		;0b0h povoleno peruen od RB0/INT a TMR0 (RB povoleno v povelu swon)
	movwf	INTCON
	bcf 	STATUS,RP0	; set file register bank to 0
	clrf	PIR1		; nuluj pznaky periferi
	movlw	0x10		;TMR1: intern hodiny, peddlika 1:2, zastaven
	movwf	T1CON		;(0)
	clrf	flags		; nuluj pznaky povelu
	clrf	tmr1f		; nuluj pznaky TMR1
	bsf 	NDATA		;nastav pznak "nov data"

; zapnut zesilovae
	call	swon
	bsf 	XDAT		; nastav pznak, e se maj poslat data

main
	btfsc	XDAT		; poadavek na zpis dat?
	call	wr_serial	;  ano - zapi data do sriovho registru (SR)
	btfsc	RCOD		; asova pouit pro rotan koder?
	goto	pwrfail		;  ano - skok
	clrwdt				; 
	btfss	PIR1,TMR1IF	; petekl asova?
	goto	$-2 		;  ne
	call	tmr5		; nastav znovu asova 5 ms
	btfsc	RXCOMM		; pijat nov povel?
	call	remote		;  ano - otestuj a zpracuj

; tmpdis - nastaven funkce displeje v zvislosti na tai tmpdis
;   pznaky XDAT a DBAL se nuluj po zpisu do SR
	movf	tmpdis,f	; doba zmny funkce displeje - pznak ZERO
	btfsc	STATUS,Z	; je asova displeje = 0? (Z=1)
	goto	dispxend		;  ano - dn akce
	decfsz	tmpdis,f	;  ne - zmeni o 1. Je te O?
	goto	dispx1		;   ne
	bsf 	XDAT		;   ano - poslat data do sriovho registru
	bcf 	DBAL
	goto	dispxend	;   hotovo
dispx1
	bsf 	DBAL 		;  ne - nastav pznak zobrazen balance
dispxend

; tmpkb - asovn ten mstnch tlatek (KB)
;   tmpkb = 0 - tlatka se natou
	movf	tmpkb,f		; bude se st klvesnice? (tmpkb = 0) - pznak ZERO
	btfsc	STATUS,Z	; je asova tlatek = 0? (Z=1)
	goto	kbcall		;  ano - ti KB
	decf	tmpkb,f		;  ne
	btfsc	STATUS,Z	; je asova tlatek = 0? (Z=1)
kbcall
	call	kbread		;  ano - peti KB
; povely typu impuls
	movf	tmpimp,f	; konec funkce typu impuls? (tmpimp = 0)
	btfsc	STATUS,Z	; je asova impulsu = 0? (Z=1)
	goto	impcall		;  ano - 
	decf	tmpimp,f	;  ne
	btfsc	STATUS,Z	; je asova impulsu = 0? (Z=1)
impcall
;	call	motorstop	;  ano - ukoni povely typu impuls (zastav motor)
	nop 				;  ano - ale zatm tady nen dn povel typu impuls

pwrfail	; powerfail - hldn napjecho napt
	clrwdt				; 
	btfss	ONSW		; je zapnuto?
	goto	$+3			;  nen - pesko test PowerFail
	btfss	PWFI		; test vstupu
	call	swoff		;  nen - vypni zesilova

; piazen asovae TMR1
	btfss	RCOD		; asova pouit pro rotan koder?
	goto	main 		;  ne - skok
	btfsc	PIR1,TMR1IF	; petekl asova?
	bcf 	RCOD		;  ano - zru piazen pro rotan koder

	goto	main

;---------------- podprogramy na page 0 -----------------

znak	;poad bit |DT|c|d|e|b|a|f|g| - (posuv. reg. s 4094)
		;poslat od nejvyho bitu, segment svt na log.0
		;podprogram umstn na page 0, jinak by se musel nastavit PCLATH
;	clrf	PCLATH	;page 0
	andlw	0x0f		;jen spodn 4 bity
	addwf	PCL,f
	retlw	0x81	;07eh	; znak 0
	retlw	0xb7	;048h	; znak 1
	retlw	0xc2	;03dh	; znak 2
	retlw	0x92	;06dh	; znak 3
	retlw	0xb4	;04bh	; znak 4
	retlw	0x98	;067h	; znak 5
	retlw	0x88	;077h	; znak 6
	retlw	0xb3	;04ch	; znak 7
	retlw	0x80	;07fh	; znak 8
	retlw	0x90	;06fh	; znak 9
	retlw	0xff	;000h	; znak " "
	retlw	0xcd	;032h	; znak "L"
	retlw	0xe0	;01fh	; znak "P"
	retlw	0x8c	;073h	; znak "b"
	retlw	0xee	;011h	; znak "r"
	retlw	0xfe	;001h	; znak "-"

;	retlw	0xa4	;05bh	; znak "H"
;	retlw	0xef	;010h	; znak "i"
;	retlw	0x8e	;071h	; znak "o"
;	retlw	0xcc	;033h	; znak "t"
;	retlw	0xd2	;02dh	; znak "stupe"

;	retlw	0xa0	;05fh	; znak "A"
;	retlw	0x8c	;073h	; znak "b"
;	retlw	0xce	;031h	; znak "c"
;	retlw	0x86	;079h	; znak "d"
;	retlw	0xc8	;037h	; znak "E"
;	retlw	0xe8	;017h	; znak "F"

command
;	movlw	0x01	; kdy program je na page 1
;	movwf	PCLATH
	movf	pdat,w	; nati povel
	andlw	0x3f	; jen spodnch 6 bit
	addwf	PCL,f
; povely z DO
; vysla DO mal       mstn tlatka      vysla bastl
;  #--#                 #--# #--# #--#       #--# (DO bastl)
;  | 4|                 |31| |36| |41|       |30|
;  #==# #--# #--#       #==# #==# #==#       #==# #--#
;  | 9| |10| | 6|       |32| |37| |42|       |29| | 4|
;  #==# #==# #==#       #==# #==# #==#       #==# #==#
;  |14| |15| |11|       |33| |38| |43|       |28| | 3|
;  #--# #==# #--#       #==# #==# #==#       #==# #--#
;       |20|            |34| |39| |44|       |27|
;  #--# #==# #--#       #==# #==# #==#       #==#
;  |24| |25| |21|       |  | |40| |45|       |26|
;  #--# #==# #--#       #--# #--# #--#       #--#
;       |30|
;       #--#
	goto	com00	; povel 00h - 0 stisk vce tlatek
	goto	nocomm	; povel 01h - tlatko 1
	goto	nocomm	; povel 02h - 2
	goto	bitsw1	; povel 03h - 3 (bastl)
	goto	swonoff	; povel 04h - 4 on-off
	goto	nocomm	; povel 05h - 5
	goto	bitsw1	; povel 06h - 6 bit.fce 3
	goto	nocomm	; povel 07h - 7
	goto	nocomm	; povel 08h - 8
	goto	spkr1	; povel 09h - 9 reproduktor 1
	goto	spkr2	; povel 0ah - 10 reproduktor 2
	goto	input3	; povel 0bh - 11 input 3
	goto	nocomm	; povel 0ch - 12
	goto	nocomm	; povel 0dh - 13
	goto	input1	; povel 0eh - 14 input 1
	goto	input2	; povel 0fh - 15 input 2
	goto	nocomm	; povel 10h - 16
	goto	nocomm	; povel 11h - 17
	goto	nocomm	; povel 12h - 18
	goto	nocomm	; povel 13h - 19
	goto	volup	; povel 14h - 20 volume +
	goto	balr	; povel 15h - 21 balance R
	goto	nocomm	; povel 16h - 22
	goto	nocomm	; povel 17h - 23
	goto	ball	; povel 18h - 24 balance L
	goto	mutesw	; povel 19h - 25 MUTE
	goto	input1	; povel 1ah - 26 (bastl)
	goto	input2	; povel 1bh - 27 (bastl)
	goto	input3	; povel 1ch - 28 (bastl)
	goto	volup	; povel 1dh - 29 (bastl)
	goto	voldwn	; povel 1eh - 30 volume -
; povely z mstnch tlatek
	goto	mutesw	; povel 1fh - 31 on-off
	goto	spkr1	; povel 20h - 32
	goto	spkr2	; povel 21h - 33
	goto	input3	; povel 22h - 34
	goto	nocomm	; povel 23h - 35 s rotanm koderem nepouit
	goto	ball	; povel 24h - 36
	goto	balr	; povel 25h - 37
	goto	bitsw2	; povel 26h - 38
	goto	input2	; povel 27h - 39
	goto	voldwn	; povel 28h - 40 s rotanm koderem nepouit
	goto	swonoff	; povel 29h - 41
	goto	nocomm	; povel 2ah - 42
	goto	bitsw1	; povel 2bh - 43
	goto	input1	; povel 2ch - 44
	goto	volup	; povel 2dh - 45 s rotanm koderem nepouit

;  Seznam povel
; nocomm  - dn povel, zvolit pro nepouit kdy tlatek
; bitsw1  - zapnout/vypnout vstup BITF1
; bitsw2  - zapnout/vypnout vstup BITF2
; spkr1   - zapne-vypne rel reproduktoru
; spkr2   - zapne-vypne rel reproduktoru
; mutesw  - zapnout/vypnout vstup MUTE
; voldwn  - zeslabit
; volup   - zeslit
; balr  - balance, pid hlasitost doprava
; ball  - balance, pid hlasitost doleva
; swonoff - zapne/vypne pstroj
; input1  - pepnn vstup, bu 1 ze 3, nebo zapnout/vypnout podle signlu MODE
; input2  - pepnn vstup, bu 1 ze 3, nebo zapnout/vypnout podle signlu MODE
; input3  - pepnn vstup, bu 1 ze 3, nebo zapnout/vypnout podle signlu MODE


;---------------- podprogramy na page 1 -----------------
		ORG	0x100	

; zpracovn povel
com00
nocomm
	bcf		XDAT		; data se nebudou zapisovat - zru pznak
	return

bitsw1	; zapne-vypne BITF1 na RB1 (bit)
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfss	pdat,7		; test pznaku prvn povel
	return				; nen to 1. povel
	btfss	BITF1		; je BITF nastaven?
	goto	bitsw1a		;  ne
	bcf 	BITF1		;  ano - nuluj BITF
	return
bitsw1a
	bsf 	BITF1		;  nastav BITF
	return

bitsw2	; zapne-vypne BITF1 na RB1 (bit)
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfss	pdat,7		; test pznaku prvn povel
	return				; nen to 1. povel
	btfss	BITF2		; je BITF nastaven?
	goto	bitsw2a		;  ne
	bcf 	BITF2		;  ano - nuluj BITF
	return
bitsw2a
	bsf 	BITF2		;  nastav BITF
	return

spkr1	; zapne-vypne rel reproduktoru
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfss	pdat,7		; test pznaku prvn povel
	return				; nen to 1. povel
	btfss	SPSW1		; je SP zapnut?
	goto	spkr1a		;  ne
	bcf 	SPSW1		;  ano - vypni SP
	return
spkr1a
	bsf 	SPSW1		; zapni SP
	return

spkr2	; zapne-vypne rel reproduktoru 2
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfss	pdat,7		; test pznaku prvn povel
	return				; nen to 1. povel
	btfss	SPSW2		; je SP zapnut?
	goto	spkr2a		;  ne
	bcf 	SPSW2		;  ano - vypni SP
	return
spkr2a
	bsf 	SPSW2		; zapni SP
	return

mutesw ; spna mute nebo rel reproduktoru
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfss	pdat,7		; test pznaku prvn povel
	return				; nen to 1. povel
	btfss	MUTE		; je mute zapnuto?
	goto	mutesw1		;  ano
	bcf 	MUTE		;  ne - nuluj MUTE (zapni mute)
	return
mutesw1
	bsf 	MUTE		;  nastav  MUTE (zru mute)
	return

voldwn	; volume down
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	clrf	tmpdis		; funkce displeje -> hlasitost
	btfsc	pdat,7		; test pznaku prvn povel
	goto	vold1		;  ano, je to 1. povel
	movfw	pdat		; nati povel
	andlw	0x1f		; vymaskuj dolnch 5 bit
	xorwf	plast,w		; a porovnej s poslednm povelem
	btfss	STATUS,Z	; jsou stejn? (Z=1)
	goto	vold1		;  ne, generuj pauzu
	movf	dlstep,f	; nastav pznak Z
	btfsc	STATUS,Z	; je dlstep = 0 ? (Z=1)
	goto	vold2		;  ano
	decf	dlstep,f	;  nen 0,
	return				;  nedlej nic
vold1
	movlw	.5			; poet povel, kter se vynechaj po prvnm kroku
	movwf	dlstep		; povely nsleduj po 62,5 ms
vold2
	movlw	.2			; krok regulace
	subwf	volume,f	; zmeni hlasitost
	btfss	STATUS,C	; peteklo to z "00" -> "ff"?
	addwf	volume,f	;  ano, tak zvti zpt
	return				;  ne - hotovo

volup	; volume up
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	clrf	tmpdis		; funkce displeje -> hlasitost
	btfsc	pdat,7		; test pznaku prvn povel
	goto	volu1		;  ano, je to 1. povel
	movfw	pdat		; nati povel
	andlw	0x1f		; vymaskuj dolnch 5 bit
	xorwf	plast,w		; a porovnej s poslednm povelem
	btfss	STATUS,Z	; jsou stejn? (Z=1)
	goto	volu1		;  ne, generuj pauzu
	movf	dlstep,f	; nastav pznak Z
	btfsc	STATUS,Z	; je dlstep = 0 ? (Z=1)
	goto	volu2		;  ano
	decf	dlstep,f	;  nen 0,
	return				;  nedlej nic
volu1
	movlw	.5			; poet povel, kter se vynechaj po prvnm kroku
	movwf	dlstep		; povely nsleduj po 62,5 ms
volu2
	movlw	.2			; krok regulace
	addwf	volume,f	; zvti hlasitost
	btfsc	STATUS,C	; peteklo to z "ff" -> "00"?
	subwf	volume,f	;  ano, tak zmeni zpt
	return				;  ne - hotovo

balr	; balance - vpravo pid, vlevo ubere
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	movlw	.200 		; dlka zmny (n * 5 ms)
	movwf	tmpdis		; zmna funkce displeje
	btfsc	pdat,7		; test pznaku prvn povel
	goto	balr1		;  ano, je to 1. povel
	movfw	pdat		; nati povel
	andlw	0x1f		; vymaskuj dolnch 5 bit
	xorwf	plast,w		; a porovnej s poslednm povelem
	btfss	STATUS,Z	; jsou stejn? (Z=1)
	goto	balr1		;  ne, generuj pauzu
	movf	dlstep,f	; nastav pznak Z
	btfsc	STATUS,Z	; je dlstep = 0 ? (Z=1)
	goto	balr2		;  ano
	decf	dlstep,f	;  nen 0,
	return				;  nedlej nic
balr1
	movlw	.5			; poet povel, kter se vynechaj po prvnm kroku
	movwf	dlstep		; povely nsleduj po 62,5 ms
balr2
	movf	balance,f	; nastav pznak ZERO
	btfss	STATUS,Z	; je balance = 0 ? (Z=1)
	goto	$+3		;  ne - normln potej
	btfss	pdat,7		; test pznaku prvn povel
	return				;  ne - zsek - pro dal potn je teba znovu stisknout tlatko
	movlw	.2			; krok regulace
	addwf	balance,f	; zvti balance
	btfsc	balance,7	; je balance zporn?
	goto	$+6 		;  ano - netestuj
	movlw	0xe0		; doplnk k hodnot balance (32), od kter se nebude zvtovat (224)
	addwf	balance,w	; nastav CARRY
	movlw	0x20 		; nastav maximum (32)
	btfsc	STATUS,C	; petekl souet?
	movwf	balance		;  nastav maximum
	return				;  ne - hotovo

ball	; balance - vlevo pid, vpravo ubere
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	movlw	.200		; dlka zmny (n * 5 ms)
	movwf	tmpdis		; zmna funkce displeje
	btfsc	pdat,7		; test pznaku prvn povel
	goto	ball1		;  ano, je to 1. povel
	movfw	pdat		; nati povel
	andlw	0x1f		; vymaskuj dolnch 5 bit
	xorwf	plast,w		; a porovnej s poslednm povelem
	btfss	STATUS,Z	; jsou stejn? (Z=1)
	goto	ball1		;  ne, generuj pauzu
	movf	dlstep,f	; nastav pznak Z
	btfsc	STATUS,Z	; je dlstep = 0 ? (Z=1)
	goto	ball2		;  ano
	decf	dlstep,f	;  nen 0,
	return				;  nedlej nic
ball1
	movlw	.5			; poet povel, kter se vynechaj po prvnm kroku
	movwf	dlstep		; povely nsleduj po 62,5 ms
ball2
	movf	balance,f	; nastav pznak ZERO
	btfss	STATUS,Z	; je balance = 0 ? (Z=1)
	goto	$+3		;  ne - normln potej
	btfss	pdat,7		; test pznaku prvn povel
	return				;  ne - zsek - pro dal potn je teba znovu stisknout tlatko
	movlw	.2			; krok regulace
	subwf	balance,f	; zmeni balance
	btfss	balance,7	; je balance kladn?
	goto	$+6 		;  ano - netestuj
	movlw	0x20		; doplnk k hodnot balance (32), od kter se nebude zmenovat (224)
	addwf	balance,w	; nastav CARRY
	movlw	0xe0 		; nastav maximum (224)
	btfss	STATUS,C	; petekl souet?
	movwf	balance		;  nastav maximum
	return				;  ne - hotovo (zatm)

swonoff	; zapne-vypne pstroj
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	ONSW	; budeme zapnat nebo vypnat?
	goto	swon	; jdi na zapnut
swoff ; vypnut
	bcf 	INTCON,RBIE	; zake peruen od zmny RB
; uloen stavu do EEPROM
	movf	portx,w		;(0)nati stav portu - vstupy z HC595
	movwf	memdata
	movlw	0x00		; adresa EEPROM, kde je uloeno nastaven zesilovae (vstupy, BITF1)
	call	eewrite
	movf	volume,w	;(0)nati hlasitost
	movwf	memdata
	movlw	0x01		; adresa EEPROM, kde je uloena hlasitost
	call	eewrite
	movf	balance,w	;(0)nati balance
	movwf	memdata
	movlw	0x02		; adresa EEPROM, kde je uloena balance
	call	eewrite
;	call	motorstop	; ukoni povely typu impuls (zastav motor) - nejsou v tto verzi
; zapni mute, odpoj bedny, zobraz Bye
	clrf	volume
	call	fade		; plynul umlen
	clrw				;
	call	wr_byte		; zapi hlasitost R=0
	call	wr_byte		; zapi hlasitost L=0
	movf	portx,w
	andlw	0xf8		; vstupy bez repro, mute zapnuto
	call	wr_byte		; zapi
	movlw	0xc8		; znak "E"
	call	wr_byte		; zapi
	movlw	0x94		; znak "Y"
	call	wr_byte		; zapi
	movlw	0x8c		; znak "b"
	call	wr_byte		; zapi
	bsf		DSTR		; zobraz
	bcf		DSTR
	bcf 	MUTEI		; rozsvi LED MUTE
	call	tmr262		; nuluj a spus asova 262 ms
	clrwdt
	btfss	PIR1,TMR1IF	;(0) petekl asova?
	goto	$-2 		;  ne, nedlej nic
; vypni zesilova
	clrw				;
	call	wr_byte		; zapi hlasitost R=0
	call	wr_byte		; zapi hlasitost L=0
	call	wr_byte		; zapi portx, vechny vstupy 0
	movlw	0xff		; vechny segmenty zhasnout = 1
	call	wr_byte		; zapi jednotky
	call	wr_byte		; zapi destky
	call	wr_byte		; zapi stovky
	bsf		DSTR		; zobraz
	bcf		DSTR
	clrf	PORTA		; vypni napjen, vstupy do nuly
	return

swon ; zapnut
	bsf 	ONSW		; zapni napjen
	bsf 	INTCON,RBIE	; povol peruen od zmny RB, kdy je pouit koder
	call	0x3f2		; adresa, kde je uloena doba ekn na PWFI * 62,5 ms (? nebylo by 65 ms lep?)
	movwf	temp		; odtud se bude odetat...
swonpw
	call	tmr62		; nastav asova 62,5 ms
	clrwdt
	btfsc	PWFI		; je napjen v podku?
	goto	swonset		;  ano, jdi dl
	btfss	PIR1,TMR1IF	;(0) petekl asova?
	goto	$-4 		;  ne, nedlej nic, jen test
	decfsz  temp,f
	goto    swonpw		;  nen 0, pokej dalch 62,5 ms
	goto	swoff 		; = 0 as vyprel - vypni
swonset
	movlw	0x00		; adresa EEPROM, kde je uloeno nastaven zesilovae (vstupy, BITF1)
	call	eeread
	movwf	portx
;
	movlw	0x01		; adresa EEPROM, kde je uloeno nastaven hlasitosti
	call	eeread
	movwf	volume 		; ulo
;
	movlw	0x02		; adresa EEPROM, kde je uloeno nastaven balance
	call	eeread
	movwf	balance		; ulo
;
	clrw				;
	call	wr_byte		; zapi hlasitost R=0
	clrw				;
	call	wr_byte		; zapi hlasitost L=0
	movf	portx,w		; vstupy
	andlw	0xf8		;  bez repro, mute zapnuto
	call	wr_byte		; zapi
	movlw	0xef		; znak "i"
	call	wr_byte		; zapi
	movlw	0xa4		; znak "H"
	call	wr_byte		; zapi
	movlw	0xff		; znak " "
	call	wr_byte		; zapi
	bsf		DSTR		; zobraz
	bcf		DSTR
; zpodn pipojen beden pi zapnut
	call	0x3f3		; adresa, kde je uloen poet opakovn prodlevy 262 ms - MUTE
	movwf	temp
	call	tmr262		; pokej 262 ms
	clrwdt
	btfss	PIR1,TMR1IF	;(0) petekl asova?
	goto	$-2 		;  ne, nedlej nic
	decfsz  temp,f
	goto    $-5
	clrf	tmpdis		; nuluj asova zmny funkce displeje
	clrf	volpga		; nuluj hlasitost
	bsf 	MUTE		; zru mute, zapni bedny
	return

input1 ; pepnn/zapnn/vypnn vstup
	btfss	ONSW	; je zesilova zapnut?
	return			;  ne - konec, nedlej nic
	btfss	MODE	; zpsob pepnn vstup
	goto	inp1b
; zapnn-vypnn
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	INP1	; je INP1 zapnut?
	goto	inp1a	;  ne
	bcf 	INP1	;  ano - vypni INP1
	return
inp1a
	bsf 	INP1	;  zapni INP1
	return
inp1b ; pepnn vstup 1 ze 3
	bcf 	INP2	;  vypni INP2
	bcf 	INP3	;  vypni INP3
	call	delay1
	bsf 	INP1	;  zapni INP1
	return

input2
	btfss	ONSW	; je zesilova zapnut?
	return			;  ne - konec, nedlej nic
	btfss	MODE	; zpsob pepnn vstup
	goto	inp2b
; zapnn-vypnn
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	INP2	; je INP1 zapnut?
	goto	inp2a	;  ne
	bcf 	INP2	;  ano - vypni INP1
	return
inp2a
	bsf 	INP2	;  zapni INP1
	return
inp2b ; pepnn vstup 1 ze 3
	bcf 	INP1	;  vypni INP1
	bcf 	INP3	;  vypni INP3
	call	delay1
	bsf 	INP2	;  zapni INP2
	return

input3
	btfss	ONSW	; je zesilova zapnut?
	return			;  ne - konec, nedlej nic
	btfss	MODE	; zpsob pepnn vstup
	goto	inp3b
; zapnn-vypnn
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	INP3	; je INP1 zapnut?
	goto	inp3a	;  ne
	bcf 	INP3	;  ano - vypni INP1
	return
inp3a
	bsf 	INP3	;  zapni INP1
	return
inp3b ; pepnn vstup 1 ze 3
	bcf 	INP1	;  vypni INP1
	bcf 	INP2	;  vypni INP2
	call	delay1
	bsf 	INP3	;  zapni INP3
	return

; pomocn podprogramy
tmr262 ; asova 262 ms     (2x swon, swoff)
	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	clrf	TMR1L		;(0) nuluj TMR1
	clrf	TMR1H		;(0) nuluj TMR1
	movlw	0x21		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 4:1 (262 ms)
	return

;tmr65 - nepouit
;	bcf 	T1CON,0		;(0) zastav T1
;	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
;	clrf	TMR1L		;(0) nuluj TMR1
;	clrf	TMR1H		;(0) nuluj TMR1
;	movlw	0x01		; nastav a spus TIMER1
;	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 1:1 (65,536 ms)
;	return

tmr62 ; asova 62,5 ms (1/16 s)               (1x swonpw)
	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	movlw	0xe9		; 62,5 ms - ni byte (0xbd pro 50 ms)
	movwf	TMR1L		;(0) ulo doplnk minus reie
	movlw	0x0b		; 62,5 ms - vy byte (0x3c pro 50 ms)
	movwf	TMR1H		;(0) ulo doplnk
	movlw	0x01		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 1
	return

tmrkoder ; asova pro rychloposuv pi rychl zmn koderu   (1x rbiupd)
	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	movlw	0x15		; ni byte
	movwf	TMR1L		;(0) ulo doplnk minus reie
	call	0x3f4		; adresa, kde je uloena dlka zmny pro rychl chod
	movwf	TMR1H		;(0) ulo dobu (n+1)*256 s
	comf	TMR1H,f		;(0) ulo doplnk
	movlw	0x01		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 1
	bsf 	RCOD		; nastav pznak, e TMR1 je pouit pro rotan koder
	return

tmr5 ; asova 5 ms (1/200 s)                (1x - rbint)
	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	movlw	0x85		; 5 ms - ni byte (0xbd pro 50 ms)
	movwf	TMR1L		;(0) ulo doplnk minus reie
	movlw	0xec		; 5 ms - vy byte (0x3c pro 50 ms)
	movwf	TMR1H		;(0) ulo doplnk
	movlw	0x01		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 1
	return

eewrite	; v registru memdata jsou data pro zpis, ve WREG adresa
	bsf 	STATUS,RP0	; set file register bank to 1 
	btfsc	EECON1,WR	;(1)dokonen pedchoz zpis?
	goto	$-1 		; zatm jet ne
	movwf	EEADR		;(1)Address to write
	movf	memdata,w
	movwf	EEDATA		;(1)
	bsf 	EECON1,WREN	;(1) Povol zpis do EEPROM
	bcf 	INTCON,GIE	; zaka peruen
	btfsc	INTCON,GIE	; See AN576
	goto	$-2
	movlw	0x55		; Unlock write
	movwf	EECON2		;(1)
	movlw	0xaa		;
	movwf	EECON2		;(1)
	bsf 	EECON1,WR	;(1)Start the write
	bsf 	INTCON,GIE	; povol peruen
	bcf 	EECON1,WREN	;(1) zaka zpis do EEPROM (probhajc zpis se neperu)
;	btfsc	EECON1,WR	;(1)wait for write complete
;	goto	$-1
	bcf 	STATUS,RP0	; set file register bank to 0
	clrwdt
	return

eeread	; ek ve W adresu EEPROM, vrac ve W naten data
	bsf 	STATUS,RP0	; set bank 1
	movwf	EEADR		;(1)Address to read
	bsf 	EECON1,RD	;(1)EE Read
	movf	EEDATA,w	;(1)Move data to W;
	bcf 	STATUS,RP0	; set bank 0
	return

delay1	; zpodn 1029 Tcy i s call a return
	movlw	0x00		;
	movwf	tmp
	nop
	decfsz	tmp,f		;
	goto	$-2			;
	return

delay30 ; zpodn 29 Tcy i s call a return
	movlw   0x08		; 08h = 29 s, 0a5h = 500 s
	movwf   temp
	decfsz  temp,f
	goto    $-1
	return

kbread ;ten tlatek
	bcf 	LOPUSH		; nov ten - vynuluj pznak stisknut tlatka
	bcf 	MPUSH		; nov ten - vynuluj pznak vce tlatek
; sloupec 1
	movlw	.30			; konstanta sloupce = 30
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1 (TRIS)
;	movlw	0xf0		; RA0 (SWC1) je vstup a je v log. 0,
	movlw	0xe0		; RA0 (SWC1) je vstup a je v log. 0,
	movwf	TRISA		;(1)  RA6 (SWC3) a RA7 (SWC2) jsou vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 2
	movlw	.35			; konstanta sloupce = 35
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
;	movlw	0x71		; RA7 (SWC2) je vstup a je v log. 0,
	movlw	0x61		; RA7 (SWC2) je vstup a je v log. 0,
	movwf	TRISA		;(1)  RA0 (SWC1) a RA6 (SWC3) jsou vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 3
	movlw	.40			; konstanta sloupce = 40
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
;	movlw	0xb1		; RA6 (SWC3) je vstup a je v log. 0,
	movlw	0xa1		; RA6 (SWC3) je vstup a je v log. 0,
	movwf	TRISA		;(1)  RA0 (SWC1) a RA7 (SWC2) jsou vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; vystupy zptky vsechny do nuly
	bsf 	STATUS,RP0	; nastav bank 1
;	movlw	0x30		; RA0 (SWC1), RA6 (SWC3) a RA7 (SWC2) jsou vstupy,
	movlw	0x20		; RA0 (SWC1), RA6 (SWC3) a RA7 (SWC2) jsou vstupy,
	movwf	TRISA		;(1)    vechny v log. 0
	bcf 	STATUS,RP0	; nastav bank 0
; vyhodnocen stisku
	btfss	LOPUSH		; stisknuto tlatko?
	goto	noswitch	; ne - jdi zpt
	bsf 	XDAT		; pznak poslat data
	btfsc	MPUSH		; stisknuto vce tlatek?
	clrf	kbcode		; ano, poli kd "0"
	btfsc	FIRSTC		; prvn prchod?
	bsf 	kbcode,7	; nastav MSB na 1
	bcf 	FIRSTC		; zru pznak 1. prchodu
	movf	kbcode,w
	movwf	pdat
	call	command
	movlw	.13
	movwf	tmpkb		; klvesnice se znova pete a za 65 ms
	movfw	pdat		; nati
	andlw	0x1f		; vymaskuj dolnch 5 bit
	movwf	plast		; a ulo posladn povel
	btfss	ONSW		; je zesilova zapnut?
	bcf 	XDAT		;  ne - zru pznak, e se maj poslat data
	return
noswitch	; nic nebylo stisknuto - jdi zpt
	bsf 	FIRSTC		; nastav pznak 1. prchodu
	return

rowrd ; zjiovn, ve kterm dku je stisknuto tlatko
	call    delay30		; pok 29 s i s call a return

	btfsc   SWR1		; testuj kter vstup - dek 1
	goto	row2		; tehle to nebyl, jdi testovat dal dek
	btfsc	LOPUSH		; bylo ji dve detekovno stisknut?
	goto	kberr		; ano, chyba
	bsf 	LOPUSH		; nastav pznak stisknut
	movlw	001h		; dek 1
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
row2
	btfsc   SWR2		; testuj kter vstup - dek 2
	goto	row3		; tehle to nebyl, jdi testovat dal dek
	btfsc	LOPUSH		; bylo ji dve detekovno stisknut?
	goto	kberr		; ano, chyba
	bsf 	LOPUSH		; nastav pznak stisknut
	movlw	002h		; dek 2
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
row3
	btfsc   SWR3		; testuj kter vstup - dek 2
	goto	row4		; tehle to nebyl, jdi testovat dal dek
	btfsc	LOPUSH		; bylo ji dve detekovno stisknut?
	goto	kberr		; ano, chyba
	bsf 	LOPUSH		; nastav pznak stisknut
	movlw	003h		; dek 3
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
row4
	btfsc   SWR4		; testuj kter vstup - dek 2
	goto	rowend		; tehle to nebyl, jdi testovat dal dek
	btfsc	LOPUSH		; bylo ji dve detekovno stisknut?
	goto	kberr		; ano, chyba
	bsf 	LOPUSH		; nastav pznak stisknut
	movlw	004h		; dek 4
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
;row5
;	btfsc   SWR5		; testuj kter vstup - dek 3
;	goto	rowend		; tehle to nebyl, jdi testovat dal dek
;	btfsc	LOPUSH		; bylo ji dve detekovno stisknut?
;	goto	kberr		; ano, chyba
;	bsf 	LOPUSH		; nastav pznak stisknut
;	movlw	005h		; dek 5
;	addwf	ksl,w		; pipoti konstantu sloupce
;	movwf	kbcode		; ulo kd tlatka
rowend
	return
kberr
	bsf 	MPUSH		; nastav pznak stisknut vce tlatek
	return

wr_serial	; zape data do sriovho posuvnho registru
	btfss	ONSW		; je zesilova zapnut? (bez tohoto testu se obas nco zapsalo i pi vypnutm zes.)
	return				;  ne - konec, nedlej nic
	call	volsmooth	; plynul zvtovn hlasitosti
	call	volumex		; vpoet hlasitosti pro lev a prav kanl
	call	display		; pprava dat pro zobrazen na displeji
	movf	volumer,w	; PGA2311 hlasitost prav kanl
	call	wr_byte
	movf	volumel,w	; PGA2311 hlasitost lev kanl
	call	wr_byte
	movf	portx,w		; port s vstupy
	call	wr_byte
	movf	djed,w		; displej jednotky
	call	znak		; kter segmenty?
	call	wr_byte
	movf	ddes,w		; displej destky
	call	znak		; kter segmenty?
	call	wr_byte
	movf	dsta,w		; displej stovky
	call	znak		; kter segmenty?
	call	wr_byte
	bsf		DSTR		; zobraz
	bcf		DSTR
	call	ledmute		; rozsvt LED MUTE
	bcf		DBAL		; zru pznak zobrazen balance
	return

volsmooth ; plynul zvtovn (a zmenovn) hlasitosti
	movf	volume,w	;porovnej nastavovanou hlasitost 
	subwf	volpga,w	;s hlasitost poslanou do PGA
	btfsc	STATUS,C	;Je nov hlasitost men nebo stejn?
	goto	volsm1		; ano - je men nebo stejn
	incf	volpga		; ne - nov je vt
	return
volsm1 ; nov hlasitost je men nebo stejn
	btfsc	STATUS,Z	;Je nov hlasitost stejn?
	goto	volsm2		; ano - je stejn
	decf	volpga		; ne - nov je men
	return
volsm2 ; nov hlasitost je stejn
	movf	volume,w	; nov hlasitost se rovnou pole
	movwf	volpga		; do PGA
	bcf		XDAT		; data se nebudou znovu zapisovat - zru pznak
	return	

volumex	; z volume a balance vypot data pro nastaven levho a pravho kanlu PGA2311
	movf	balance,w	;balance
	movwf	balneg
	comf	balneg,f
	incf	balneg,f	;dvojkov doplnk hodnoty balance
;hlasitost pravho kanlu (data pro PGA2311)
	btfsc	balance,7	;je balance zporn?
	goto	$+6 		; ano - netestuj
	movlw	.246		;doplnk k hodnot balance, od kter se nebude hlasitost kanlu zvtovat
	addwf	balance,w	; nastav CARRY
	movf	balance,w	;nemn CARRY
	btfsc	STATUS,C	;petekl souet?
	movlw	.10 		; ano - nastav mez
	addwf	volpga,w	;hlasitost pravho kanlu
	btfsc	balance,7	;je balance zporn? (pro zpornou balanci neguj CARRY)
	call	negcarry	; ano - neguj CARRY
	btfss	STATUS,C	;petekl souet?
	goto	$+4 		;  ne - u jen ulo
	movlw	0x00		;  ano - piprav doln mez pro peteen z minima na maximum
	btfsc	volpga,7	;byla hlasitost velk?
	movlw	0xff		;  ano - bylo to peteen z maxima na minimum
	movwf	volumer
;hlasitost levho kanlu (data pro PGA2311)
	movf	balneg,w
	btfsc	balneg,7	;je dvojkov doplnk balance zporn?
	goto	$+6 		; ano - netestuj
	movlw	.246		;doplnk k hodnot balance, od kter se nebude hlasitost kanlu zvtovat
	addwf	balneg,w	; nastav CARRY
	movf	balneg,w	;nemn CARRY
	btfsc	STATUS,C	;petekl souet?
	movlw	.10 		; ano - nastav mez
	addwf	volpga,w	;hlasitost
	btfsc	balneg,7	;je dvojkov doplnk balance zporn? (pro zporn neguj CARRY)
	call	negcarry	; ano - neguj CARRY
	btfss	STATUS,C	;petekl souet?
	goto	$+4 		;  ne - u jen ulo
	movlw	0x00		;  ano - piprav doln mez pro peteen z minima na maximum
	btfsc	volpga,7	;byla hlasitost velk?
	movlw	0xff		;  ano - bylo to peteen z maxima na minimum
	movwf	volumel
	return

negcarry
	btfss	STATUS,C	; je CARRY nastaven?
	goto	$+3 		;  ne
	bcf 	STATUS,C	;  ano - nuluj CARRY
	return
	bsf 	STATUS,C	;  nastav CARRY
	return

ledmute	;rozsvt LED MUTE kdy je mute nebo dn repro nen zapnut
	btfss	MUTE		; test MUTE
	goto	ledmuteon
	btfsc	SPSW1		; test zapnut repro 1
	goto	ledmuteoff
	btfss	SPSW2		; test zapnut repro 2
	goto	ledmuteon
ledmuteoff
	bsf 	MUTEI		; zhasni LED
	return
ledmuteon
	bcf 	MUTEI		; rozsvi LED
	return
;--------------------------------------------------------------------------------------
display	; data pro displej - z volume (0-255, hlasitost po 0,5 dB) se zobraz slo 0-127 (po 1 dB)
		; zobrazuje hlasitost stereovhu
	bcf 	STATUS,C	; nuluj CARRY
	rrf 	volume,w	; dl daj volume dvma
	btfsc	DBAL		; bude se msto hlasitosti zobrazovat balance?
	call	dispbal		; ano, piprav data
; Hex to bcd. On start hex value must be in W
; rutina podle: http://www.microchip.com/forums/m322713.aspx (P Lameijn)
hex2bcd
	movwf	djed	;units
	movlw	d'0'
	movwf	ddes	;tens
	movwf	dsta	;hundreds
h2b_xxx
	movlw	d'100'
	subwf	djed,w	;units,w
	btfss	STATUS,C
	goto	h2b_xx
	movwf	djed	;units
	incf	dsta,f	;hundreds,f
	goto	h2b_xxx
h2b_xx
	movlw	d'10'
	subwf	djed,w	;units,w
	btfss	STATUS,C
	goto	h2b_x
	movwf	djed	;units
	incf	ddes,f	;tens,f
	goto	h2b_xx
h2b_x

; potlaen nevznamnch nul, L-P u balance
	movlw	0x0a		; znak " "
	movf	dsta,f		; nastav pznak ZERO
	btfss	STATUS,Z	; je dsta = 0 ? (Z=1)
	goto	displ1		;  ne
	movwf	dsta		;  ano - ulo pozici " "
	movf	ddes,f		; nastav pznak ZERO
	btfsc	STATUS,Z	; je ddes = 0 ? (Z=1)
	movwf	ddes		;  ano - ulo pozici " "
displ1
	btfss	DBAL		; bude se msto hlasitosti zobrazovat balance?
	return				; ne - hotovo
	movlw	0x0b		; znak "L"
	movwf	dsta		; ulo
	btfsc	balance,7	; je balance zporn?
	return				;  ano - hotovo
	incf	dsta,f		; znak "P"
	movf	balance,f	; nastav pznak ZERO
	btfsc	STATUS,Z	; je balance = 0 ? (Z=1)
	incf	dsta,f		;  ano - znak "b"
	return

dispbal	; piprav data pro zobrazen balance - pevod na absolutn hodnotu
	rrf 	balance,w	; dl dvma, daj po 1 dB
	btfss	balance,7	;je balance kladn?
	return				; ano - hotovo
	xorlw	0x7f		;balance
	addlw	0x01		;dvojkov doplnk hodnoty balance
	return

wr_byte		; data na zapsn do 4094 ve WREG
			; Q1 nejni, Q8 nejvy bit
			; WREG data |DT|c|d|e|b|a|f|g| segment displeje
	movwf	sdbuf
	bcf		DCLK
	movlw	.8
	movwf	tmp
write_loop
	rlf		sdbuf,f		;pesu nejvy bit do carry
	bcf		DDAT
	btfsc	STATUS,C	;test C
	bsf		DDAT		;kdy C=1, zapi 1, segment nesvt
	bsf		DCLK		;zapisovac impuls (toggle DCLK)
	bcf		DDAT		;nulovn vstupu kvli sdlen vvodu
	bcf		DCLK
	decfsz	tmp,f		;smyka 8x (loop 8 times)
	goto	write_loop
	rlf		sdbuf,w		; vrt pvodn obsah do WREG
	return

vodwn	; volume down rotanm koderem
	clrf	tmpdis		; funkce displeje -> hlasitost
	movlw	.2			; krok regulace
	btfsc	RCOD		; asova pouit pro rotan koder?
	movlw	.10			;  ano - zvti krok
	subwf	volume,f	; zmeni hlasitost
	btfss	STATUS,C	; peteklo to z "00" -> "ff"?
	addwf	volume,f	;  ano, tak zvti zpt
	return				;  ne - hotovo

voup	; volume up rotanm koderem
	clrf	tmpdis		; funkce displeje -> hlasitost
	movlw	.2			; krok regulace
	btfsc	RCOD		; asova pouit pro rotan koder?
	movlw	.10			;  ano - zvti krok
	addwf	volume,f	; zvti hlasitost
	btfsc	STATUS,C	; peteklo to z "ff" -> "00"?
	subwf	volume,f	;  ano, tak zmeni zpt
	return				;  ne - hotovo

remote	; pijat povel z DO
; test integrity dat
	call	0x3f1		; adresa, kde je uloen offset
	addwf	pdat,w		;piti ofset k datm
	addwf	kdat,w		;piti kontroln data
	addlw	0x01		;piti jedna
	btfss	STATUS,Z	;vyla nula?
	goto	remoterr	;ne - chyba
	btfss	NDATA		;nov data?
	goto	remoterr	;ne - chyba
; kontrola adresy
	rrf 	pdat,w		; st s adresou pesunuta na bity 4 a 5
	andlw	0x30		; jen adresu z povelu
	movwf	temp		; ulo
	swapf	temp,f		; adresu z povelu na bity 0 a 1
	call	0x3f0		; adresa, kde je uloena adresa povelu
	andlw	0x03		; jen bity 0 a 1
	xorwf	temp,w		; porovnej
	btfss	STATUS,Z	; jsou stejn? (Z=1)
	goto 	remoterr	;  ne, povel se ignoruje
; Tady je povel pijat, zkontrolovn a uloen v pdat.
;  |x|0|0|x|x|x|x|x| registr pdat
;   |     +-+-+-+-+ - povel DO (kd tlatka)
;   +-------------- - pznak prvnho vysln povelu (generuje vysla DO)
; Nsledujc st programu povel vykon
;exec
	bsf 	XDAT		; nastav pznak, e se maj poslat data
	call	command
	movfw	pdat		; nati
	andlw	0x1f		; vymaskuj dolnch 5 bit
	movwf	plast		; a ulo posladn povel
	btfss	ONSW		; je zesilova zapnut?
	bcf 	XDAT		;  ne - zru pznak, e se maj poslat data
remoterr
	bcf 	RXCOMM		;nuluj pznak povel pijat
	return

fade
	call	wr_serial	;  ano - zapi data do sriovho registru (SR)
	clrwdt				; 
	btfss	PIR1,TMR1IF	; petekl asova?
	goto	$-2 		;  ne
	call	tmr5		; nastav znovu asova 5 ms
	btfsc	XDAT		; poadavek na zpis dat?
	goto	fade		;  ano - zapi data do sriovho registru (SR)
	return				;  ne


		ORG	0x3f0
	retlw	0x00		;adresa povelu (0 a 3)
	retlw	0x47		;ofset povelu (0 a ffh)
	retlw	0x10		;doba ekn na PWFI (n * 62,5 ms)
	retlw	0x04		;doba ekn na zapnut reproduktoru MUTE (n * 262 ms)
	retlw	.100		;doba mezi impulsy pro rychl chod koderu

; initialize eeprom locations

		ORG	0x2100
	DE	0x2b, 0xa0, 0x00	; stav, hlasitost, balance
	DE	"Prijimac DO pro zesilovac s PGA2311. v1.7 (koder) "
	DE	"Jaroslav Belza  2015 www.belza.cz"


	END                       ; directive 'end of program'
