;**********************************************************************
;   Pijma DO pro zesilova s motorovm potenciometrem              *
;**********************************************************************
;    Filename:	    rx-motor.asm                                      *
;    Author:        Jaroslav Belza                                    *
;**********************************************************************
;                           ----------U-----------  
;         pep.vstup IN3 <-|RA2              RA1|-> pep.vstup IN2
; zapnut zesilovae ONSW <-|RA3              RA0|-> pep.vstup IN1
;  spna repro/mute MUTE <-|RA4(OC)          RA7|-> motor 1
;         input MODE, Vpp ->|RA5/MCLR         RA6|-> motor 2
;                     GND --|Vss              Vdd|-- +5V
;      vstup signlu z RX ->|RB0/INT      RB7/PGD|<- tlatka dek 3, PGD
;   hldn napjen PWFI ->|RB1          RB6/PGC|<- tlatka dek 2, PGC
;      tlatka sloupec 1 <-|RB2              RB5|<- tlatka dek 1
;      tlatka sloupec 2 <-|RB3          RB4/PGM|-> bit.fce 1
;                           ----------------------
;**********************************************************************

	list      p=16f628a           ; list directive to define processor
	#include <p16f628a.inc>        ; processor specific variable definitions

	errorlevel  -302              ; suppress message 302 from list file

	__CONFIG   _CP_OFF & _CPD_OFF & _LVP_OFF & _BOREN_OFF & _MCLRE_OFF & _WDT_ON & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT



;***** VARIABLE DEFINITIONS
w_temp        EQU     0x7e        ; variable used for context saving 
status_temp   EQU     0x7f        ; variable used for context saving

tmp		equ	0x24	;promnn zpoovac smyky
kbcode	equ	0x25	;kd mstnch tlatek
temp	equ	0x27	;pomocn registr
timer	equ	0x28	;uloen obsah TMR0
pdat	equ	0x29	;pijat byte
kdat	equ	0x2a	;kontroln byte
cimp	equ	0x2c	;poitn pijatch bit (dekrementuje se)
ksl 	equ	0x2d	;pro vpoet kdu tlatka

flags	equ	0x70	; |x|x|x|x|x|x|x|x| pznaky
;					;  | | | | | | | +- 1 - nov data
;					;  | | | | | | +--- 1 - povel pijat
;					;  | | | | | +----- 1 - povel z mstnch tlatek
;					;  | | | | +------- 1 - 1.povel z mstnch tlatek
;					;  | | | +--------- 1 - prznak stisknut mstnho tlacitka
;					;  | | +----------- 1 - prznak stisknut vce mstnch tlacitek
;					;  | +------------- 1 - povel typu impuls
;					;  +--------------- 1 - povel u byl vykonn
	#define	NDATA	flags,0		; nov data
	#define	RXCOMM	flags,1		; povel pijat
	#define	LOCOMM	flags,2		; povel z mstnch tlatek
	#define	FIRSTC	flags,3		; 1. povel z mstnch tlatek
	#define	LOPUSH	flags,4		; prznak stisknut mstnho tlacitka
	#define	MPUSH	flags,5		; prznak stisknut vce mstnch tlacitek
	#define	IMPS	flags,6		; povel typu impuls
;
	#define	INP1	PORTA,0		; vstup pro pepna vstup
	#define	INP2	PORTA,1		; vstup pro pepna vstup
	#define	INP3	PORTA,2		; vstup pro pepna vstup
	#define	ONSW	PORTA,3		; vstup - signl zapnut (1 = zapnuto)
	#define	MUTE	PORTA,4		; vstup pro odpojen reproduktor (0 = odpojeno, mute)
	#define	MODE	PORTA,5		; vstup pro vbr zpsobu pepnn vstup
	#define	MOTR	PORTA,6		; vstup - mstek motoru
	#define	MOTL	PORTA,7		; vstup - mstek motoru

	#define	IRIN	PORTB,0		; vstup od pijmae DO
	#define	PWFI	PORTB,1		; vstup detekce vypnut (power fail indicator)
	#define	SWC1	PORTB,2		; vstup tlatka sloupec 1
	#define	SWC2	PORTB,3		; vstup tlatka sloupec 2
	#define	BITF1	PORTB,4		; vstup bitov funkce 1
	#define	SWR1	PORTB,5		; vstup tlatka dek 1
	#define	SWR2	PORTB,6		; vstup tlatka dek 2
	#define	SWR3	PORTB,7		; vstup tlatka dek 3


;**********************************************************************
		ORG	0x000	; processor reset vector
	bcf 	STATUS,RP0		; set file register bank to 0
	clrf	PORTA			;(0)vynuluj port A
	clrf	PORTB			;(0)vynuluj port B
 	goto	init			; go to beginning of program

		ORG	0x004	; interrupt vector location
	movwf	w_temp			; save off current W register contents
	movf	STATUS,w		; move status register into W register
	movwf	status_temp		; save off contents of STATUS register
;
	btfss	INTCON,T0IF		;peruen od TMR0?
	goto	indata			;ne
; peruen od asovae - petekl asova
	bsf		STATUS,RP0		;bank 1
	bsf 	OPTION_REG,T0CS	;(1)zastav asova pipojenm vstupu na RA4
	bsf 	NDATA			;nastav pznak "nov data"
	bcf 	INTCON,T0IE		;zaka peruen od asovae
	bcf 	INTCON,T0IF		;nuluj pznak peteen TMR0
	goto	errint
indata ; pijat impuls na GP2/INT
	bcf		STATUS,RP0		;Bank 0
	btfss	INTCON,INTF		;peruen od GP2/INT?
	goto	errint			;ne CHYBA !! - nemlo by nastat
	bcf 	INTCON,INTF		;nuluj pznak peteen GP2/INT

	btfss	NDATA			;test pznaku "nov data". Pokud je pznak nastaven
							;me to bt prvn impuls povelu
	goto	datatst			;nen to prvn impuls
	bcf 	NDATA			;nuluj pznak "nov data"
	movlw	.8				;oekvan poet pijatch bit
	movwf	cimp
	clrf	TMR0			;(0)nuluj ta
	clrf	pdat			;nuluj registry pro natn prijatch dat
	clrf	kdat
	bsf		STATUS,RP0		;Bank 1
	bcf 	OPTION_REG,T0CS	;(1)spus asova pipojenm vstupu na CLKOUT
	bcf 	INTCON,INTF		;nuluj pznak peruen od RB0/INT
	bsf 	INTCON,T0IE		;povol peruen od asovae TMR0
	goto	endint

datatst	;podle stavu asovae ur krtk chyba, bity 00, 01, 10, 11 nebo dlouh chyba
	movfw	TMR0		;(0)pesu obsah TMR0
	clrf	TMR0		;(0)nuluj ta
	movwf	timer		;
;te1
	movlw	0x6f		;111 do WREG
	addwf	timer,w		;sete timer a WREG. Kdy souet petee, byl timer >145
	btfsc	STATUS,C	;test CARRY
	goto	errdata		;byl dlouh
	movlw	0x39		;57 do WREG
	subwf	timer,w		;odete WREG od timer. Kdy rozdl podtee, byl timer <57
	btfss	STATUS,C	;test CARRY
	goto	errdata		;byl krtk
; rozdlen na skupiny 0x a 1x
	movlw	0xa5		;165 do WREG - hranin hodnota mezi 01 a 10
	addwf	timer,w		;pite hranin hodnotu k timer. Kdy petee C=1 jsou pijaty bity 10 nebo 11
	btfsc	STATUS,C	;test CARRY
	goto	data10		;byl "10"
; test pro "00" a "01"
	rlf 	kdat,f		;CARRY=0, prvn nulu sta narolovat
	rlf 	pdat,f
	movlw	0xb8		;184 do WREG - hranin hodnota mezi 00 a 01
	addwf	timer,w		;pite hranin hodnotu k timer. Kdy petee C=1 jsou pijaty bity 01
	rlf 	kdat,f		;CARRY nastaven, sta narolovat
	rlf 	pdat,f
	goto	next
data10 ; test pro "10" a "11"
	rlf 	kdat,f		;CARRY=1, prvn 1 sta narolovat
	rlf 	pdat,f
	movlw	0x8d		;141 do WREG - hranin hodnota mezi 10 a 11
	addwf	timer,w		;pite hranin hodnotu k timer. Kdy petee C=1 jsou pijaty bity 11
	rlf 	kdat,f		;CARRY nastaven, sta narolovat
	rlf 	pdat,f
next
	decfsz	cimp,f		;pijat dal bit, odpotej
	goto	endint
	bsf 	RXCOMM		;nastav pznak "povel pijat"
errdata
	bsf 	NDATA		;nastav pznak "nov data"
	clrf	cimp		;nuluj poitadlo (asi nen nutn)
errint	;peruen nen od asovae TMR0 ani od RB0/INT. Nastavit znova
		;INTCON, OPTION_REG, ppadn PIE1 a PIR1 (budou-li pouity)
	bcf		STATUS,RP0	;bank 0
	clrf	TMR0		;(0)nuluj asova
endint
	movf	status_temp,w	; retrieve copy of STATUS register
	movwf	STATUS			; restore pre-isr STATUS register contents
	swapf	w_temp,f
	swapf	w_temp,w		; restore pre-isr W register contents
	retfie					; return from interrupt

init
; kompartor off
	movlw	0x07		;vypne kompartor zpisem do CMCON
	movwf	CMCON		;(0)vvody RA0 a RA4 pak lze pout jako I/O
; port & TMR0 set
	bsf		STATUS,RP0	;Bank 1
	movlw	0x20		;RA5 je vstup, ostatn RA vstupy
	movwf	TRISA		;(1) nastav I/O
	movlw	0xe3		;RB0, RB1, RB5-RB7 jsou vstupy, RB2-RB4 vstupy
	movwf	TRISB		;(1) nastav I/O
	movlw	0x33		;zapni WPU, peruen RB0/INT na sestupnou hranu,
	movwf	OPTION_REG	;(1) asova TMR0 vypnut pipojenm na RA4,dlika 16 pro asova
; konfigurace peruen
	movlw	0xb0		;0b0h povoleno peruen od RB0/INT a TMR0 (0F0h jestli bude TMR1)
	movwf	INTCON
	bcf 	STATUS,RP0	; set file register bank to 0
	clrf	PIR1		; nuluj pznaky periferi
	movlw	0x10		;TMR1: intern hodiny, peddlika 1:2, zastaven
	movwf	T1CON		;(0)
	clrf	flags
	bsf 	NDATA		;nastav pznak "nov data"
; zapnut zesilovae
	call	swon

main
;	btfsc	PIR1,TMR1IF	; petekl asova?
	call	kbread		; ano - peti mstn tlatka
	btfsc	LOCOMM		;povel z mstnch tlatek?
	goto	exec		;ano, vynechej kontrolu kdat, adresy a ofsetu
	btfss	RXCOMM		;pijat nov povel?
	goto	remote		;ne
; test integrity dat
	call	0x3f1		; adresa, kde je uloen offset
	addwf	pdat,w		;piti ofset k datm
	addwf	kdat,w		;piti kontroln data
	addlw	0x01		;piti jedna
	btfss	STATUS,Z	;vyla nula?
	goto	remote		;ne - chyba
	btfss	NDATA		;nov data?
	goto	remote		;ne - chyba
; kontrola adresy
	rrf 	pdat,w		; st s adresou pesunuta na bity 4 a 5
	andlw	0x30		; jen adresu z povelu
	movwf	temp		; ulo
	swapf	temp,f		; adresu z povelu na bity 0 a 1
	call	0x3f0		; adresa, kde je uloena adresa povelu
	andlw	0x03		; jen bity 0 a 1
	xorwf	temp,w		; porovnej
	btfss	STATUS,Z	; jsou stejn? (Z=1)
	goto 	remote		;  ne, povel se ignoruje

; Tady je povel pijat, zkontrolovn a uloen v pdat.
;  |x|0|0|x|x|x|x|x| registr pdat
;   |     +-+-+-+-+ - povel DO (kd tlatka)
;   +-------------- - pznak prvnho vysln povelu (generuje vysla DO)
; Nsledujc st programu povel vykon
exec
	call	command
	bcf 	RXCOMM		;nuluj pznak povel pijat
;	bsf 	flags,7		;nastav pznak povel vykonn (asi zbyten)
	call	delay1
remote
	bcf 	LOCOMM		;nuluj pznak mstn tlatka
; peteen asovae
	btfss	PIR1,TMR1IF	; petekl asova?
	goto	remoteon		;  ne, nedlej nic
	btfss	IMPS		; povel typu impuls?
	goto	remoteon		;  ne, nedlej nic
	call	motorstop	; ukoni povely typu impuls (zastav motor)
	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	bcf 	IMPS		; povel typu impuls ukonen
remoteon
; hldn napjecho napt
	btfss	ONSW		; je zapnuto?
	goto	$+3			;  nen - pesko test PowerFail
	btfss	PWFI		; test vstupu
	call	swoff		;  nen - vypni zesilova
	clrwdt				; 
	goto	main

;---------------- podprogramy na page 0 -----------------

command
;	movlw	0x01	; program je na page 1
;	movwf	PCLATH
	movf	pdat,w	; nati povel
	andlw	0x3f	; jen spodnch 6-5 bit
	addwf	PCL,f
; povely z DO
; tlatka vysla DO mal
;  #--#          
;  | 4|          
;  #==# #--# #--#
;  | 9| |10| | 6|
;  #==# #==# #==#
;  |14| |15| |11|
;  #--# #==# #--#
;       |20|     
;  #--# #==# #--#
;  |24| |25| |21|
;  #--# #==# #--#
;       |30|
;       #--#
	goto	com00	; povel 00h - 0 stisk vce tlatek
	goto	nocomm	; povel 01h - tlatko 1
	goto	nocomm	; povel 02h - 2
	goto	nocomm	; povel 03h - 3
	goto	swonoff	; povel 04h - 4 on-off
	goto	nocomm	; povel 05h - 5
	goto	bitsw1	; povel 06h - 6 bit.fce 3
	goto	nocomm	; povel 07h - 7
	goto	nocomm	; povel 08h - 8
	goto	nocomm	; povel 09h - 9 bit.fce 1
	goto	nocomm	; povel 0ah - 10 bit.fce 2
	goto	input3	; povel 0bh - 11 input 3
	goto	nocomm	; povel 0ch - 12
	goto	nocomm	; povel 0dh - 13
	goto	input1	; povel 0eh - 14 input 1
	goto	input2	; povel 0fh - 15 input 2
	goto	nocomm	; povel 10h - 16
	goto	nocomm	; povel 11h - 17
	goto	nocomm	; povel 12h - 18
	goto	nocomm	; povel 13h - 19
	goto	motorr	; povel 14h - 20 volume +
	goto	motorr	; povel 15h - 21 balance R
	goto	nocomm	; povel 16h - 22
	goto	nocomm	; povel 17h - 23
	goto	motorl	; povel 18h - 24 balance L
	goto	mutesw	; povel 19h - 25 MUTE
	goto	nocomm	; povel 1ah - 26
	goto	nocomm	; povel 1bh - 27
	goto	nocomm	; povel 1ch - 28
	goto	nocomm	; povel 1dh - 29
	goto	motorl	; povel 1eh - 30 volume -
; povely z mstnch tlatek
	goto	swonoff	; povel 1fh - 31
	goto	mutesw	; povel 20h - 32
	goto	bitsw1	; povel 21h - 33
	goto	input3	; povel 22h - 34
	goto	input2	; povel 23h - 35
	goto	input1	; povel 24h - 36

;  Seznam povel
; nocomm  - dn povel, zvolit pro nepouit kdy tlatek
; bitsw1  - zapnout/vypnout vstup BITF1
; mutesw  - zapnout/vypnout vstup MUTE
; motorr  - oten motoru doprava, povel typu impuls, jen po dobu stisku tlatka
; motorl  - oten motoru doleva, povel typu impuls, jen po dobu stisku tlatka
; swonoff - zapne/vypne pstroj
; input1  - pepnn vstup, bu 1 ze 3, nebo zapnout/vypnout podle signlu MODE
; input2  - pepnn vstup, bu 1 ze 3, nebo zapnout/vypnout podle signlu MODE
; input3  - pepnn vstup, bu 1 ze 3, nebo zapnout/vypnout podle signlu MODE
; swon	-	zapne zesilova
; swoof	-	vypne zesilova

nocomm
	return

;---------------- podprogramy na page 1 -----------------
		ORG	0x100	

; zpracovn povel
com00
	return

bitsw1	; zapne-vypne BITF1 na RB1 (bit)
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfss	pdat,7		; test pznaku prvn povel
	return				; nen to 1. povel
	btfss	BITF1		; je BITF nastaven?
	goto	bitsw1a		;  ne
	bcf 	BITF1		;  ano - nuluj BITF
	return
bitsw1a
	bsf 	BITF1		;  nastav BITF
	return

mutesw ; spna mute nebo rel reproduktoru
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfss	pdat,7		; test pznaku prvn povel
	return				; nen to 1. povel
	btfss	MUTE		; je mute zapnuto?
	goto	mutesw1		;  ano
	bcf 	MUTE		;  ne - nuluj MUTE (zapni mute)
	return
mutesw1
	bsf 	MUTE		;  nastav  MUTE (zru mute)
	return

motorr
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfsc 	MOTL		; zru povel motor L (RA7)
	goto	motorstop
	call	tmr65		; nuluj a spus asova 65 ms
	bsf 	MOTR		; zapni motor R (RA6)
	bsf 	IMPS		; nastav pznak povel typu impuls
	return
motorl
	btfss	ONSW		; je zesilova zapnut?
	return				;  ne - konec, nedlej nic
	btfsc 	MOTR		; zru povel motor R (RA6)
	goto	motorstop
	call	tmr65		; nuluj a spus asova 65 ms
	bsf 	MOTL		; zapni motor L (RA7)
	bsf 	IMPS		; nastav pznak povel typu impuls
	return
motorstop
	bcf 	MOTL		; zastav motor (RA7)
	bcf 	MOTR		; zastav motor (RA6)
	return

swonoff	; zapne-vypne pstroj
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	ONSW	; budeme zapnat nebo vypnat?
	goto	swon	; jdi na zapnut
swoff ; vypnut
	bcf 	MUTE	; zapni mute, odpoj bedny
; uloen stavu do EEPROM
	movf	PORTA,w		;(0)nati stav portu - stav pepnae vstup
	andlw	0x07		; vymaskuj nejni 3 bity
	movwf	temp
	btfsc	BITF1		; je BITF nastaven?
	bsf 	temp,4		;  ano - ulo do temp
	movf	temp,w		; piprav uloen stavu
	bsf 	STATUS,RP0	; set file register bank to 1 
	movwf	EEDATA		;(1)
	clrw				; adresa EEPROM, kde je uloeno nastaven zesilovae (vstupy, BITF1)
	movwf	EEADR		;(1)Address to read
	call	eewrite
	bcf 	STATUS,RP0	; set file register bank to 0
	movlw	0x08
	andwf	PORTA,f
	clrf	PORTB
	call	tmr262		; nuluj a spus asova 262 ms
	clrwdt
	btfss	PIR1,TMR1IF	;(0) petekl asova?
	goto	$-2 		;  ne, nedlej nic
	bcf 	ONSW		; vypni napjen
	return

swon ; zapnut
	bsf 	ONSW		; zapni napjen
	call	0x3f2		; adresa, kde je uloena doba ekn na PWFI * 65 ms
	movwf	temp		; odtud se bude odetat...
	btfsc	PWFI		; je napjen v podku?
	goto	swonset		;  ano, jdi dl
swonpw
	call	tmr65		;  ne, pokej 65 ms
	clrwdt
	btfsc	PWFI		; je napjen v podku?
	goto	swonset		;  ano, jdi dl
	btfss	PIR1,TMR1IF	;(0) petekl asova?
	goto	$-4 		;  ne, nedlej nic, jen test
	decfsz  temp,f
	goto    swonpw
	bcf 	ONSW		; as vyprel - vypni napjen
	return
swonset
	clrw				; adresa EEPROM, kde je uloeno nastaven zesilovae (vstupy, BITF1)
	call	eeread
	movwf	temp
	btfsc	temp,4		; testuj pvodn stav BITF1
	bsf 	BITF1		; nastav vstup BITF1
	andlw	0x07		; vymaskuj nastaven vstup
	addwf	PORTA,f		; zapi na port A (vstupy, mute on (0), zapnuto (1), motor stop (00))
; zpodn pipojen beden pi zapnut
	call	0x3f3		; adresa, kde je uloen poet opakovn prodlevy 262 ms - MUTE
	movwf	temp
	call	tmr262		; pokej 262 ms
	clrwdt
	btfss	PIR1,TMR1IF	;(0) petekl asova?
	goto	$-2 		;  ne, nedlej nic
	decfsz  temp,f
	goto    $-5
	bsf 	MUTE		; zru mute, zapni bedny
	return

input1 ; pepnn/zapnn/vypnn vstup
	btfss	ONSW	; je zesilova zapnut?
	return			;  ne - konec, nedlej nic
	btfss	MODE	; zpsob pepnn vstup
	goto	inp1b
; zapnn-vypnn
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	INP1	; je INP1 zapnut?
	goto	inp1a	;  ne
	bcf 	INP1	;  ano - vypni INP1
	return
inp1a
	bsf 	INP1	;  zapni INP1
	return
inp1b ; pepnn vstup 1 ze 3
	bcf 	INP2	;  vypni INP2
	bcf 	INP3	;  vypni INP3
	call	delay1
	bsf 	INP1	;  zapni INP1
	return

input2
	btfss	ONSW	; je zesilova zapnut?
	return			;  ne - konec, nedlej nic
	btfss	MODE	; zpsob pepnn vstup
	goto	inp2b
; zapnn-vypnn
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	INP2	; je INP1 zapnut?
	goto	inp2a	;  ne
	bcf 	INP2	;  ano - vypni INP1
	return
inp2a
	bsf 	INP2	;  zapni INP1
	return
inp2b ; pepnn vstup 1 ze 3
	bcf 	INP1	;  vypni INP1
	bcf 	INP3	;  vypni INP3
	call	delay1
	bsf 	INP2	;  zapni INP2
	return

input3
	btfss	ONSW	; je zesilova zapnut?
	return			;  ne - konec, nedlej nic
	btfss	MODE	; zpsob pepnn vstup
	goto	inp3b
; zapnn-vypnn
	btfss	pdat,7	; test pznaku prvn povel
	return			; nen to 1. povel
	btfss	INP3	; je INP1 zapnut?
	goto	inp3a	;  ne
	bcf 	INP3	;  ano - vypni INP1
	return
inp3a
	bsf 	INP3	;  zapni INP1
	return
inp3b ; pepnn vstup 1 ze 3
	bcf 	INP1	;  vypni INP1
	bcf 	INP2	;  vypni INP2
	call	delay1
	bsf 	INP3	;  zapni INP3
	return

; pomocn podprogramy
tmr262
	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	clrf	TMR1L		;(0) nuluj TMR1
	clrf	TMR1H		;(0) nuluj TMR1
	movlw	0x21		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 4:1 (262 ms)
	return

tmr65
	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	clrf	TMR1L		;(0) nuluj TMR1
	clrf	TMR1H		;(0) nuluj TMR1
	movlw	0x01		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 1:1 (65,536 ms)
	return

eeread	; ek ve W adresu EEPROM, vrac ve W naten data
	bsf 	STATUS,RP0	; set bank 1
	movwf	EEADR		;(1)Address to read
	bsf 	EECON1,RD	;(1)EE Read
	movf	EEDATA,w	;(1)Move data to W;
	bcf 	STATUS,RP0	; set bank 0
	return

eewrite
;	bsf 	STATUS,RP0	; Bank 1
	bsf 	EECON1,WREN	;(1) Enable write
	bcf 	INTCON,GIE	; Disable INTs
	movlw	0x55		; Unlock write
	movwf	EECON2		;(1)
	movlw	0xaa		;
	movwf	EECON2		;(1)
	bsf 	EECON1,WR	;(1)Start the write
	bsf 	INTCON,GIE	; Enable INTS
	return

delay1		;zpodn 1000 Tcy i s call a return
	movlw	0x00			;
	movwf	tmp
	nop
	decfsz	tmp,f		;
	goto	$-2			;
	return

delay30
	movlw   0x08		; 08h = 29 s, 0a5h = ??
	movwf   temp
	decfsz  temp,f
	goto    $-1
	return

kbread ;cten tlacitek
	bcf 	LOPUSH		; nov cten - vynuluj prznak stisknut tlacitka
	bcf 	MPUSH		; nov cten - vynuluj prznak vce tlacitek
; sloupec 1
	movlw	0x1e		; konstanta sloupce = 30
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
	bcf 	SWC1		; nastav sloupec 1 jako vstup - log.0
	bsf 	SWC2		; nastav sloupec 2 do vysok impedance - jako vstup
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 2
	movlw	0x21		; konstanta sloupce = 33
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
	bcf 	SWC2		; nastav sloupec 2 jako vstup - log.0
	bsf 	SWC1		; nastav sloupec 1 do vysok impedance - jako vstup
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; precti, ktery radek
; vystupy zptky vsechny do nuly
	bsf 	STATUS,RP0	; nastav bank 1
	bcf 	SWC1		; nastav sloupec 1 jako vstup - log.0
	bcf 	SWC2		; nastav sloupec 2 jako vstup - log.0
	bcf 	STATUS,RP0	; nastav bank 0
; vyhodnocen stisku
	btfss	LOPUSH		; stisknuto tlactko?
	goto	noswitch	; ne - jdi zpt
	btfsc	MPUSH		; stisknuto vce tlacitek?
	clrf	kbcode		; ano, poli kd "0"
	btfsc	FIRSTC		; prvn prchod?
	bsf 	kbcode,7	; nastav MSB na 1
	bcf 	FIRSTC		; zru pznak 1. prchodu
	bsf 	LOCOMM		; nastav pznak povel z mstnch tlatek

	bcf 	T1CON,0		;(0) zastav T1
	bcf 	PIR1,TMR1IF ;(0) nuluj pznak peteen
	movlw	0xe9		; 62,5 ms - ni byte (0bdh pro 50 ms)
	movwf	TMR1L		;(0) ulo doplnk minus reie
	movlw	0x0b		; 62,5 ms - vy byte (03ch pro 50 ma)
	movwf	TMR1H		;(0) ulo doplnk
	movlw	0x01		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 1
	movf	kbcode,w
	movwf	pdat
	return
noswitch	; nic nebylo stisknuto - jdi zpt
	bsf 	FIRSTC		; nastav pznak 1. prchodu
	return

rowrd ; zjistovan, ve kterem radku je stisknuto tlacitko
	call    delay30		; pock 29 s i s call a return

	btfsc   SWR1		; testuj ktery vstup - radek 1
	goto	row2		; tehle to nebyl, jdi testovat dalsi radek
	btfsc	LOPUSH		; bylo jiz drive detekovano stisknuti?
	goto	kberr		; ano, chyba
	bsf 	LOPUSH		; nastav priznak stisknuti
	movlw	0x01		; radek 1
	addwf	ksl,w		; pripocti konstantu sloupce
	movwf	kbcode		; uloz kod tlacitka
row2
	btfsc   SWR2		; testuj ktery vstup - radek 2
	goto	row3		; tehle to nebyl, jdi testovat dalsi radek
	btfsc	LOPUSH		; bylo jiz drive detekovano stisknuti?
	goto	kberr		; ano, chyba
	bsf 	LOPUSH		; nastav priznak stisknuti
	movlw	0x02		; radek 2
	addwf	ksl,w		; pripocti konstantu sloupce
	movwf	kbcode		; uloz kod tlacitka
row3
	btfsc   SWR3		; testuj ktery vstup - radek 3
	goto	rowend		; tehle to nebyl, jdi testovat dalsi radek
	btfsc	LOPUSH		; bylo jiz drive detekovano stisknuti?
	goto	kberr		; ano, chyba
	bsf 	LOPUSH		; nastav priznak stisknuti
	movlw	0x03		; radek 3
	addwf	ksl,w		; pripocti konstantu sloupce
	movwf	kbcode		; uloz kod tlacitka
rowend
	return
kberr
	bsf 	MPUSH		; nastav priznak stisknut vce tlacitek
	return

		ORG	0x3f0
	retlw	0x00		;adresa povelu (0 a 3)
	retlw	0x47		;ofset povelu (0 a ffh)
	retlw	0x10		;doba ekn na PWFI (n * 65,5 ms)
	retlw	0x04		;doba ekn na zapnut reproduktoru MUTE (n * 262 ms)

; initialize eeprom locations

		ORG	0x2100
	DE	0x01	; stav zesilovae
	DE	"Prijimac DO pro zesilovac s motorovym potenciometrem. v1.4a. "
	DE	"Jaroslav Belza  2014 www.belza.cz"


	END                       ; directive 'end of program'
