;**********************************************************************
;    Name:          IR transmitter 36 kHz                             *
;    Author:        Jaroslav Belza 2014                               *
;**********************************************************************
;                         ----------U-----------
;                   +5V --|Vdd              Vss|-- GND
;    vstup imp. na LED --|RA5/oscin    RA0/PGD|-- dek 1 KB (ICSP data)
;            dek 5 KB --|RA4/oscout   RA1/PGC|-- dek 2 KB (ICSP clk)
; (ICSP Vpp) dek 4 KB --|RA3/MCLR/Vpp RA2/INT|-- dek 3 KB
;          sloupec 6 KB --|RC5              RC0|-- sloupec 1 KB
;          sloupec 5 KB --|RC4              RC1|-- sloupec 2 KB
;          sloupec 4 KB --|RC3              RC2|-- sloupec 3 KB
;                         ----------------------
;**********************************************************************
; verze genertor 36 kHz
;**********************************************************************

	list      p=16f630           ; list directive to define processor
	#include <p16F630.inc>       ; processor specific variable definitions
	errorlevel  -302             ; suppress message 302 from list file

	__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT

;***** VARIABLE DEFINITION

tmpi		equ	0x30		; pomocn promnn genertoru burstu
tmpn		equ	0x31		; poet impuls v burstu (pro smycku)
burstn		equ	0x32		; poet impuls v burstu
bitnum		equ	0x33		; cyklus pi vysln dat
tmp 		equ	0x35		; promnn ekac smycky
ksl 		equ	0x37		; konstanta sloupce
pdat		equ	0x2d		; pam dat povelu
kdat		equ	0x2e		; kontroln byte povelu
kbcode		equ	0x2f		; kd stisknutho tlatka (1 az 30)

state		equ	0x3f		; |x|x|x|x|x|x|x|x| stav vysln povelu
;							;  | | | | | | | +- 1 - prvn prchod / 0 - opakovan teni
;							;  | | | | | | +--- 1 - detekovno stisknut tlatka
;							;  | | | | | +----- 1 - detekovno stisknut vce tlatek

	#define OUTL    PORTA,5	;vstup pro budi LED

;**********************************************************************
		ORG     0x000             ; processor reset vector

; peruen se nepouv

	call	0x3FF		; retrieve factory calibration value
	bsf 	STATUS,RP0	; set file register bank to 1
	movwf	OSCCAL		; update register with factory cal value
	bcf 	STATUS,RP0	; set file register bank to 0
; vypnut kompartoru (nejmen spoteba)
	movlw	0x07
	movwf	CMCON		;(0)
; nastaven portu
	clrf	PORTA		;(0) vynuluj port A
	clrf	PORTC		;(0) vynuluj port C
	bsf 	STATUS,RP0	; nastav bank 1
	movlw	0x1f		; nastav RA0 a RA4
	movwf	TRISA		;(1)  jako vstupy, RA5 je vstup
	movwf	IOCA		;(1) peruen od zmny RA0 a RA4
	movwf	WPUA		;(1) nastav pull-up na vstupy
	movlw	0x7f		; nastav OPTION_REG
	movwf	OPTION_REG	;(1) -> povol pull-up
	clrf	TRISC		;(1) cel port C je vstup
; vypnut peruen
	clrf	PIE1		; vypne peruen od perifri
	bcf 	STATUS,RP0	; nastav bank 0
	clrf	T1CON		;(0) nuluje nastaven TIMER1, z neznmho dvodu nutn u nkterch IO
	movlw	0x08		; povolen peruen jen od zmny RA (mon 40h kdy i PEIE)
	movwf	INTCON		;
main
	bcf 	INTCON,RAIF	; vynuluj pznak peruen od RA
	sleep				; nen co dlat
	bsf 	state,0		; nastav 1. prchod
	call	delay1ms	; prodleva na odstrann nhodnho sputn

sendloop
	clrf	PIR1		;(0) nuluj pznaky peruen
	bcf 	T1CON,0		;(0) zastav T1
	movlw	0xe9		; 62,5 ms - ni byte (0xbd pro 50 ms)
	movwf	TMR1L		;(0) ulo doplnk minus reie
	movlw	0x0b		; 62,5 ms - vy byte (0x3c pro 50 ms)
	movwf	TMR1H		;(0) ulo doplnk
	movlw	0x01		; nastav a spus TIMER1
	movwf	T1CON		;(0) T1 ON, intern takt, peddlika = 1

	call	kbread		; pete klatka a podle vysledku je:
; nastaven pznak state,1 - stisknut tlatko
; nastaven pznak state,2 - stisknuto vce tlatek
; v kbcode uloen kd tlatka 1 a 30
	btfss	state,1		; stisknuto tlatko?
	goto	main		; ne - jdi spt
	btfsc	state,2		; stisknuto vce tlatek?
	clrf	kbcode		; ano, poli kd "0"
;kontrola na stejn kd
;	movf	kbcode,w	; pesu kbdata
;	xorwf	pdat,w		; porovnej s pdat
;	btfss	STATUS,Z	; jsou stejn? (Z=1)
;	bsf 	state,0		;  ne, nastav 1. prchod	
;	movf	kbcode,w	; pesu kbdata
;	movwf	pdat		;  do pdat pro kontrolu pi dalm ten
;konec kontroly
	btfsc	state,0		; prvn prchod?
	bsf 	kbcode,7	; nastav MSB na 1
	call	send2		; vyle data
	bcf 	state,0		; zru pznak 1. prchodu
; pauza 62,5 ms dan nastavenm asovae TIMER1
	btfsc	PIR1,TMR1IF	; petekl asova?
	goto	sendloop	;  ano - dal koleko...
	goto    $-2			;  ne - jet ekej

; podprogramy
send2	; vyle data, dvoubitov kdovn 1052/1325/1670/2104 s
	call	0x3F0		; vrt adresu povelu
	andlw	0x03		; jen nejni 2 bity
	movwf	kdat		; doasn ulo
	rlf 	kdat,f		; pesune adresu
	swapf	kdat,w		; na pozici bit 5 a 6
	addwf	kbcode,f	; ulo byte povelu - pznak (bit 7) + adresa (bity 5,6)
						; + kd tlatka(5 bit, bity 0 a 4)
	call	0x3F1		; vrt adresu ofsetu
	addwf	kbcode,w	; povel + ofset
	movwf	kdat		; ulo
	comf	kdat,f		; kontroln data - negovan (povel+ofset)

	call	burst		; vyle sadu impuls, poet impuls je ve WREG
	movlw	0x08		; poet vyslanch bit
	movwf	bitnum
	nop 				; asov kompenzace
sendloop2
	rlf 	kdat,f		; rotuj do CARRY
	rlf 	kbcode,f	; nejvy bit dat do CARRY
	btfsc	STATUS,C	; test log.1
	goto	send23
	rlf 	kdat,f		; rotuj do CARRY
	rlf 	kbcode,f	; nejvy bit dat do CARRY
	btfsc	STATUS,C	; test log.1
	call	add1gap		; o tohle je impuls "01" del (273 s)
	call	add0gap		; mezera pro "00" (1052 s)
	call	burst		; poli buta
	decfsz	bitnum,f
	goto	sendloop2	; dal bit
	return
send23
	rlf 	kdat,f		; rotuj do CARRY
	rlf 	kbcode,f	; nejvy bit dat do CARRY
	btfsc	STATUS,C	; test log.1
	call	add3gap		; o tohle je impuls "11" del (434 s)
	call	add2gap		; mezera pro "10" (1670 s)
	call	burst		; poli buta
	decfsz	bitnum,f
	goto	sendloop2	; dal bit
	return

burst ; vyrob skupinu impulsu - burst, WREG = pocet impulsu
	nop
	movlw   0x0a		; poet impuls v burstu
	movwf   tmpn
burst1
	bsf     OUTL		; zahj impuls
	movlw   0x04		; trvn impulsu
	movwf   tmpi
	decfsz  tmpi,f
	goto    $-1
	bcf     OUTL		; ukon impuls
	movlw   0x03		; trvn mezery
	movwf   tmpi
	decfsz  tmpi,f
	goto    $-1
	decfsz  tmpn,f
	goto    burst1
	return

add0gap ;mezera mezi bursty pro "00" (+285 burst = 1050 s)
	movlw   0xbb		;0xbc = 753 s
	movwf   tmpi
	nop
	decfsz  tmpi,f
	goto    $-2
	return

add1gap ;mezera navc mezi bursty pro "01"
	movlw   0x59		; 0x59 = 274 s
	movwf   tmpi		; celkem 1325 s
	nop
	nop
	decfsz  tmpi,f
	goto    $-1
	return

add2gap ;mezera mezi bursty pro "10"
	call	add1gap		; +273 s
	movlw   0xda		; 0xe4 = 1373 s
	movwf   tmpi		; celkem 1670 s
	nop
	nop
	decfsz  tmpi,f
	goto    $-3
	return

add3gap ;mezera navc mezi bursty pro "11"
	movlw   0x8f		; 0xd1 = 1050 s, 0xd2 = 1055 s
	movwf   tmpi		; 0d1 -> log.1 celkem 2101 s
	decfsz  tmpi,f
	goto    $-1
	return

delay1ms ;1001 s pro 0f9h
	movlw   0xf9		; 0xf8 = 997 s, 0xa5 = 665 s
	movwf   tmpi
	nop
	decfsz  tmpi,f
	goto    $-2
	return

delay30
	movlw   0x08		; 0x08 = 29 s
	movwf   tmpi
	decfsz  tmpi,f
	goto    $-1
	return

kbread ;ten tlatek
	bcf 	state,1		; nov ten - vynuluj pznak stisknut tlatka
	bcf 	state,2		; nov ten - vynuluj pznak vce tlatek
; sloupec 1
	clrf	ksl 		; konstanta sloupce = 0
	bsf 	STATUS,RP0	; nastav bank 1
	movlw	0x3e		; RC0 je vstup a je v log. 0,
	movwf	TRISC		;(1)  ostatn piny portu jako vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 2
	movlw	0x05		; konstanta sloupce = 5
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
	movlw	0x3d		; RC1 je vstup a je v log. 0,
	movwf	TRISC		;(1)  ostatn piny portu jako vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 3
	movlw	0x0a		; konstanta sloupce = 10
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
	movlw	0x3b		; RC2 je vstup a je v log. 0,
	movwf	TRISC		;(1)  ostatn piny portu jako vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 4
	movlw	0x0f		; konstanta sloupce = 15
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
	movlw	0x37		; RC3 je vstup a je v log. 0,
	movwf	TRISC		;(1)  ostatn piny portu jako vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 5
	movlw	0x14		; konstanta sloupce = 20
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
	movlw	0x2f		; RC4 je vstup a je v log. 0,
	movwf	TRISC		;(1)  ostatn piny portu jako vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; sloupec 6
	movlw	0x19		; konstanta sloupce = 25
	movwf	ksl
	bsf 	STATUS,RP0	; nastav bank 1
	movlw	0x1f		; RC5 je vstup a je v log. 0,
	movwf	TRISC		;(1)  ostatn piny portu jako vstupy - vysok impedance
	bcf 	STATUS,RP0	; nastav bank 0
	call	rowrd		; peti, kter dek
; vstupy zptky vechny do nuly
	bsf 	STATUS,RP0	; nastav bank 1
	clrf	TRISC		;(1) port C je vstup
	bcf 	STATUS,RP0	; nastav bank 0

	return

rowrd ; zjiovan, ve kterm dku je stisknuto tlatko
	call    delay30		; pok 29 s i s call a return

	btfsc   PORTA,0		; testuj kter vstup - dek 1
	goto	row2		; tehle to nebyl, jdi testovat dal dek
	btfsc	state,1		; bylo ji dve detekovno stisknuti?
	goto	kberr		; ano, chyba
	bsf 	state,1		; nastav pznak stisknuti
	movlw	0x01		; dek 1
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
row2
	btfsc   PORTA,1		; testuj kter vstup - dek 2
	goto	row3		; tehle to nebyl, jdi testovat dal dek
	btfsc	state,1		; bylo ji dve detekovno stisknuti?
	goto	kberr		; ano, chyba
	bsf 	state,1		; nastav pznak stisknuti
	movlw	0x02		; dek 2
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
row3
	btfsc   PORTA,2		; testuj kter vstup - dek 3
	goto	row4		; tehle to nebyl, jdi testovat dal dek
	btfsc	state,1		; bylo ji dve detekovno stisknuti?
	goto	kberr		; ano, chyba
	bsf 	state,1		; nastav pznak stisknuti
	movlw	0x03		; dek 3
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
row4
	btfsc   PORTA,3		; testuj kter vstup - dek 4
	goto	row5		; tehle to nebyl, jdi testovat dal dek
	btfsc	state,1		; bylo ji dve detekovno stisknuti?
	goto	kberr		; ano, chyba
	bsf 	state,1		; nastav pznak stisknuti
	movlw	0x04		; dek 4
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
row5
	btfsc   PORTA,4		; testuj kter vstup - dek 5
	goto	rowend		; tehle to nebyl, jdi testovat dal dek
	btfsc	state,1		; bylo ji dve detekovno stisknuti?
	goto	kberr		; ano, chyba
	bsf 	state,1		; nastav pznak stisknuti
	movlw	0x05		; dek 5
	addwf	ksl,w		; pipoti konstantu sloupce
	movwf	kbcode		; ulo kd tlatka
rowend
	return
kberr
	bsf 	state,2		; nastav pznak stisknut vce tlatek
	return

;adresa a ofset povelu 
		ORG	0x3f0
	retlw	0x00		;adresa povelu (0 a 3)
	retlw	0x47		;ofset povelu (0 a ffh)

; initialize eeprom locations

		ORG	0x2100
;	DE	0x00, 0x33		;adresa (0-7) a ofset povelu (0-ffh)
	DE  "DO 30 tlacitek 1 byte (1052/1325/1670/2104 s) s kontrolou,"
	DE  " priznakem a opakovanim 62,5ms* 07.2014 * jbelza@centrum.cz"


		END                       ; directive 'end of program'



